﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

using InSimDotNet;
using InSimDotNet.Packets;

namespace Dizplay_Cruise
{
    public class clsUser
    {
        protected bool _inserver = true;
        public bool InServer
        {
            get { return _inserver; }
            set { _inserver = value; }
        }

        protected NewConnectionPacket _ncn = null;
        public NewConnectionPacket NCN
        {
            get { return _ncn; }
            set { _ncn = value; }
        }

        protected bool _ontrack = false;
        public bool OnTrack
        {
            get { return _ontrack; }
            set { _ontrack = value; }
        }

        protected NewPlayerPacket _npl = null;
        public NewPlayerPacket NPL
        {
            get { return _npl; }
            set { _npl = value; }
        }

        private CompCar _compcar = null;
        public CompCar CompCar
        {
            get { return _compcar; }
            set
            {
                _compcar = value;

                if (value != null)
                {
                    Button.Sequence.Queue(SequenceHUD, UCID: NCN.ConnectionId, SpecialValue: CompCar.Speed.Kph, SpecificFunction: "display_speedlimit");
                }
            }
        }

        private ButtonPacket[] _buttons = new ButtonPacket[256];
        public ButtonPacket[] Buttons
        {
            get { return _buttons; }
            set { _buttons = value; }
        }

        protected UInt64 _distance = 0;
        /// <summary>
        /// User distance driven (in lfs units: 65536 = 1metre)
        /// </summary>
        public UInt64 Distance
        {
            get { return _distance; }
            set
            {
                _distance = value;

                Button.Sequence.Queue(SequenceHUD, UCID: NCN.ConnectionId, SpecialValue: Distance, SpecificFunction: "display_distance");
            }
        }

        protected UInt64 _cash = 300050;
        /// <summary>
        /// User current cash in cents (e.g. 300000 = $3000)
        /// </summary>
        public UInt64 Cash
        {
            get { return _cash; }
            set
            {
                _cash = value;

                Button.Sequence.Queue(_sequencehud, _ncn.ConnectionId, SpecialValue: _cash, SpecificFunction: "display_cash");
            }
        }

        protected string _sequencehud;
        /// <summary>
        /// The HUD sequence that the user has selected.
        /// </summary>
        public string SequenceHUD
        {
            get { return _sequencehud; }
            set { _sequencehud = value; }
        }
    }
}
